/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.patchouli;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.interop.patchouli.PatchouliUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MultiCraftingProcessor
implements IComponentProcessor {
    private List<class_3955> recipes;
    private boolean shapeless = true;
    private int longestIngredientSize = 0;
    private boolean hasCustomHeading;

    public void setup(class_1937 level, IVariableProvider vars) {
        List names = vars.get("recipes").asStream().map(IVariable::asString).collect(Collectors.toList());
        this.recipes = new ArrayList<class_3955>();
        for (String name : names) {
            class_3955 recipe = (class_3955)PatchouliUtils.getRecipe(class_3956.field_17545, new class_2960(name));
            if (recipe != null) {
                this.recipes.add(recipe);
                if (this.shapeless) {
                    this.shapeless = !(recipe instanceof class_1869);
                }
                for (class_1856 ingredient : recipe.method_8117()) {
                    int size = ingredient.method_8105().length;
                    if (this.longestIngredientSize >= size) continue;
                    this.longestIngredientSize = size;
                }
                continue;
            }
            HexAPI.LOGGER.warn("Missing crafting recipe " + name);
        }
        this.hasCustomHeading = vars.has("heading");
    }

    public IVariable process(class_1937 level, String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            if (!this.hasCustomHeading) {
                return IVariable.from((Object)this.recipes.get(0).method_8110(level.method_30349()).method_7964());
            }
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            int shapedX = index % 3;
            int shapedY = index / 3;
            ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
            for (class_3955 recipe2 : this.recipes) {
                if (recipe2 instanceof class_1869) {
                    class_1869 shaped = (class_1869)recipe2;
                    if (shaped.method_8150() < shapedX + 1) {
                        ingredients.add(class_1856.field_9017);
                        continue;
                    }
                    int realIndex = index - shapedY * (3 - shaped.method_8150());
                    class_2371 list = recipe2.method_8117();
                    ingredients.add(list.size() > realIndex ? (class_1856)list.get(realIndex) : class_1856.field_9017);
                    continue;
                }
                class_2371 list = recipe2.method_8117();
                ingredients.add(list.size() > index ? (class_1856)list.get(index) : class_1856.field_9017);
            }
            return PatchouliUtils.interweaveIngredients(ingredients, this.longestIngredientSize);
        }
        if (key.equals("output")) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(recipe -> recipe.method_8110(level.method_30349())).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("shapeless")) {
            return IVariable.wrap((Boolean)this.shapeless);
        }
        return null;
    }
}

